<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="robots" content="noindex, nofollow">

		<title>Samsung AI Memory</title>

		<link rel="apple-touch-icon" sizes="180x180" href="/hr/assets/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="/hr/assets/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="/hr/assets/favicon-16x16.png">
		<link rel="manifest" href="/hr/assets/site.webmanifest">

		<link rel="stylesheet" href="/hr/assets/style/style.css" type="text/css">
	</head>
	<body>
		<div class="signup">
			<div class="signup-content">
				<img src="/hr/assets/logo.svg" class="signup-logo">

				<h1>Memory game</h1>
				<p class="signup-description">Zaigrajte našu memory igru te isprobajte svoju brzinu, jer možda ćete baš vi biti jedan od naših dobitnika.</p>

				<form name="prijava" method="POST" action="/">
					<input type="text" name="imeprezime" placeholder="Ime i prezime" class="imeprezime" autocomplete="off">
					<input type="email" name="email" placeholder="Email adresa" class="email" autocomplete="off">
					<input type="tel" name="telefon" placeholder="Broj mobilnog telefona" class="telefon" autocomplete="off">

					<label class="checkbox">Prihvaćam <a href="/hr/HR_Nagradni natjecaj_Galaxy AI Kiosk Hrvatska_v3.docx">uvjete i pravila korištenja</a>.
						<input type="checkbox" class="uvjetikoristenja">
						<span class="checkmark"></span>
					</label>

					<button>Zaigraj igru</button>

					<div class="error hidden">
						<p></p>
					</div>
				</form>
			</div>
		</div>
		<div class="game hidden">
			<div class="game-content">
				<div class="game-header">
					<img src="/hr/assets/logo.svg" class="game-logo">
					<div class="game-timer">
						<p>Vaše vrijeme</p>
						<p class="game-currentTime">0:00</p>
					</div>
				</div>
				<div class="game-cards">

				</div>
			</div>
		</div>
		<div class="leaderboards hidden">
			<img src="/hr/assets/logo.svg" class="leaderboards-logo">

			<p class="leaderboards-currentScore text-center">Vaš trenutni rezultat: <span></span></p>
			<p class="leaderboards-currentPosition text-center">Trenutno se nalazite na <span></span>. mjestu</p>
			<p class="text-center">Zaigrajte sutra ponovno</p>

			<h2>Trenutno kolo</h2>
			<div class="leaderboards-content">

			</div>
		</div>

		<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
		<script src="/hr/assets/js/required.js"></script>
	</body>
</html>
